(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     33139,        961]*)
(*NotebookOutlinePosition[     34512,       1001]*)
(*  CellTagsIndexPosition[     34468,        997]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Derivadas e integrales ", "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Lo que debes aprender en este cuaderno es lo que sigue.
Representar gr\[AAcute]ficamente rectas tangentes y normales a la \
gr\[AAcute]fica de una funci\[OAcute]n.
Calcular y evaluar derivadas de cualquier orden de una funci\[OAcute]n.
Calcular polinomios de Taylor y representarlos gr\[AAcute]ficamente para \
aproximar una funci\[OAcute]n.
Usar los comandos Integrate[ ] y NIntegrate[ ] con opciones apropiadas para \
calcular integrales de funciones de una variable.\
\>", "Text"],

Cell["\<\
Derivada de una funci\[OAcute]n. Observaciones sobre la definici\[OAcute]n de \
derivadas\
\>", "Section"],

Cell[TextData[{
  "Es muy f\[AAcute]cil representar las derivadas de primero, segundo y \
tercer orden de una funci\[OAcute]n de una variable. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lo hace igual que t\[UAcute]. Compru\[EAcute]balo."
}], "Text"],

Cell[BoxData[{
    \(f[x_] := x^4\  + Sin[x^2]\), 
    \(\(f'\)[x]\  (*\ 
      para\ escribir\ '\ debes\ usar\ la\ tecla\ junto\ al\ cero\ *) \), 
    \(\(\(f'\)'\)[x]\), 
    \(\(\(\(f'\)'\)'\)[x]\)}], "Input"],

Cell[TextData[{
  "Por tanto, definida una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[x]\)]],
  " de una variable ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe derivarla y no necesitas definir aparte su derivada ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\ '\)[x]\)]],
  ". Para derivadas de orden mayor que tres se usa el comando \"D[f[x],{x,n}]\
\" (que tambi\[EAcute]n se puede escribir ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_{1, n}f\)]],
  ") que proporciona la derivada n-\[EAcute]sima. Hay una sutileza que debes \
tener en cuenta al definir derivadas. El siguiente ejemplo la pone de \
manifiesto."
}], "Text"],

Cell[BoxData[{
    \(f[x_] := x^2*Tan[x]\), 
    \(h[x_] := D[f[x], {x, 5}]\), 
    \(h[3]\)}], "Input"],

Cell["\[DownQuestion]Entiendes lo que pasa? Veamos.", "Text"],

Cell[BoxData[
    \(FullForm[h[3]]\)], "Input"],

Cell[TextData[{
  "Ahora ya debes saber lo que est\[AAcute] pasando. Al definir h[x] con una \
igualdad diferida (:=) lo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha almacenado como definici\[OAcute]n de h[x] ",
  StyleBox["no",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es la derivada quinta de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(x\^2\),
            "TraditionalForm"], \(Tan[x]\)}], TraditionalForm]]],
  " sino el comando ",
  Cell[BoxData[
      \(TraditionalForm\`"D[f[x], {x, 5}]"\)]],
  "  pero dicho comando no se ha ejecutado pues se trata de una ",
  StyleBox["asignaci\[OAcute]n diferida",
    FontSlant->"Italic"],
  " por lo que dicho comando se ejecuta ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de que se llama a la funci\[OAcute]n h[x]. Por eso cuando escribes h[3] \
lo que est\[AAcute]s diciendo a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es que derive f[3] respecto a la variable 3 cinco veces y, claro est\
\[AAcute], 3 no es una variable v\[AAcute]lida para derivar. Naturalmente, \
esto se arregla definiendo h[x] con la asignaci\[OAcute]n inmediata (=)."
}], "Text"],

Cell[BoxData[{
    \(Clear[h]\), 
    \(h[x_] = D[f[x], {x, 5}]; \nh[3]\)}], "Input"],

Cell[TextData[{
  "La diferencia est\[AAcute] en que ahora ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ejecuta inmediatamente el comando ",
  "D[f[x], {x, 5}] y su resultado lo asigna a h[x]."
}], "Text"],

Cell[CellGroupData[{

Cell["Rectas tangentes y secantes a una curva", "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n vamos a utilizar lo que sabemos de \
pr\[AAcute]cticas anteriores para visualizar la interpretaci\[OAcute]n geom\
\[EAcute]trica de la derivada. Conviene recordar que si ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es una funci\[OAcute]n derivable en el punto ",
  StyleBox["a, ",
    FontSlant->"Italic"],
  "el valor de su derivada en ese punto, ",
  StyleBox["f '(a)",
    FontSlant->"Italic"],
  ", es la pendiente de la recta tangente a la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en el punto ",
  StyleBox["(a,f(a))",
    FontSlant->"Italic"],
  ". \nLa recta que pasa por dos puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, c)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((b, d)\)\ \)\)]],
  "con ",
  Cell[BoxData[
      \(TraditionalForm\`a \[NotEqual] b\)]],
  StyleBox[", ",
    FontSlant->"Italic"],
  "tiene como ecuaci\[OAcute]n cartesiana ",
  Cell[BoxData[
      \(TraditionalForm
      \`y = \(\(c - d\)\/\(a - b\)\) x + \(a\ d - b\ c\)\/\(a - b\)\)]],
  ". Definimos el comando siguiente:"
}], "Text"],

Cell[BoxData[{
    \(\(recta[{a_, c_}, {b_, d_}]\)[x_] := 
      \(c - d\)\/\(a - b\)*x + \(a*d - b*c\)\/\(a - b\) /; 
        a \[NotEqual] b\), 
    \(\(recta[{a_, c_}, {a_, d_}]\)[x_] := "\<es una recta vertical\>"\)}], 
  "Input"],

Cell[TextData[{
  "La tangente a la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " es la recta de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y - f(a) = f\ ' \((a)\) \((x - a)\)\)]],
  ". Definimos el comando siguiente:"
}], "Text"],

Cell[BoxData[
    \(\(tangente[f_, a_]\)[x_] := f[a] + \(f'\)[a]*\((x - a)\)\)], "Input"],

Cell[TextData[{
  "Ahora puedes representar gr\[AAcute]ficamente una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", su tangente en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((a, f(a))\)\ \)\)]],
  "y las rectas secantes por los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((a + h, f(a + h))\)\)]],
  " para distintos valores de ",
  StyleBox["h",
    FontSlant->"Italic"],
  ".  En la siguiente animaci\[OAcute]n se ve la gr\[AAcute]fica de la par\
\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 6 - \((x - 3)\)\^2\)]],
  " en azul, la recta tangente en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, f(1))\)\)]],
  " en negro y las rectas secantes en rojo. El c\[OAcute]digo al final es \
para que todas las celdas generadas se mantengan juntas."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]; \nf[x_] := \(-\((x - 3)\)^2\) + 6; \n
    Do[Plot[{f[x], \(tangente[f, 1]\)[x], 
          \(recta[{1, f[1]}, {1 - h, f[1 - h]}]\)[x]}, {x, \(-2\), 5}, 
        PlotRange \[Rule] {\(-2\), 8}, 
        PlotStyle -> {RGBColor[0, 0, 1], RGBColor[0, 0, 0], 
            RGBColor[1, 0, 0]}, ImageSize -> {443, 273}], {h, \(-3\), 
        \(- .2\),  .2}]\), 
    \(SelectionMove[EvaluationNotebook[], All, GeneratedCell]; \n
    FrontEndTokenExecute["\<CellGroup\>"]\), 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"]
}, Open  ]],

Cell[TextData[{
  "Aqu\[IAcute] tienes la familia de las tangentes a la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(x\^2\/4 . \)\)]]
}], "Text"],

Cell[BoxData[{
    \(Clear[f]; f[x_] := x^2/4\), 
    \(\(Show[\[IndentingNewLine]\t
      Table[\[IndentingNewLine]\t\t
        Plot[{f[x], \(tangente[f, \(-3\) + 6  k/30]\)[x]}, {x, \(-3\), 3}, 
          PlotRange \[Rule] {\(-2\), 2.5}, 
          PlotStyle \[Rule] {{Hue[0], Thickness[ .01]}, {Hue[ .65]}}, 
          AspectRatio \[Rule] 1.1, 
          DisplayFunction \[Rule] Identity\[IndentingNewLine]\t\t\t], 
        \[IndentingNewLine]{k, 1, 29}], \[IndentingNewLine]\t\t
      DisplayFunction \[Rule] $DisplayFunction]; \)\)}], "Input"],

Cell[CellGroupData[{

Cell["Cocientes incrementales", "Section"],

Cell["\<\
Podemos aproximar la derivada de una funci\[OAcute]n por los cocientes \
incrementales. \
\>", "Text"],

Cell[BoxData[
    \(\(\(cocienteinc[f_, h_]\)[x_] := \(f[x + h] - f[x]\)\/h\  (*
      para\ valores\ peque\[NTilde]os\ de\ h\ tenemos\ una\ funci\[OAcute]n\ 
        que\ aproxima\ a\ la\ derivada\ de\ f*) \)\)], "Input"]
}, Open  ]],

Cell[TextData[{
  "Calculando el l\[IAcute]mite cuando ",
  StyleBox["h",
    FontSlant->"Italic"],
  " tiende a cero de los cocientes incrementales obtenemos la funci\[OAcute]n \
derivada. Veamos un ejemplo con la   funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ Exp[x\^2]\)\)]],
  ":"
}], "Text"],

Cell[BoxData[
    \(g[x_] = E\^\(x\^2\); \nLimit[\(cocienteinc[g, h]\)[x], h -> 0]\)], 
  "Input"],

Cell["M\[AAcute]ximos y m\[IAcute]nimos relativos", "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n vamos a aprender a localizar extremos relativos de \
una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". Para ello calcularemos los puntos cr\[IAcute]ticos de la funci\[OAcute]n \
que, como sabes, son las soluciones de la ecuaci\[OAcute]n: ",
  StyleBox["f '(x)=0",
    FontSlant->"Italic"],
  ". A veces podemos calcular dichas soluciones de forma exacta con ",
  StyleBox["Solve[ ]",
    FontWeight->"Bold"],
  ", pero lo m\[AAcute]s usual es calcularlas de forma aproximada con ",
  StyleBox["NSolve[ ]",
    FontWeight->"Bold"],
  " o ",
  StyleBox["FindRoot[ ].",
    FontWeight->"Bold"]
}], "Text"],

Cell["Ejemplo 1", "Subsubsection"],

Cell[TextData[{
  "Comencemos calculando los extremos relativos de la funci\[OAcute]n polin\
\[OAcute]mica ",
  StyleBox["f(x)=",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(x\^5 + x\^4 - 11  x\^3 - 9  x\^2 + 18  x + 10\), 
          StyleBox[" ",
            FontSlant->"Italic"]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] = x^5 + x^4 - 11  x^3 - 9  x^2 + 18  x + 10; \n
    Plot[f[x], {x, \(-4\), 4}]; \)}], "Input"],

Cell[TextData[{
  "A simple vista observamos que hay:\na) un m\[AAcute]ximo relativo entre -3 \
y -2,\nb) un m\[IAcute]nimo relativo entre -2 y -1,\nc) un m\[AAcute]ximo \
relativo entre 0 y 1,\nd) un m\[IAcute]nimo relativo entre 2 y 3.\nEn \
cualquier caso, y dada la simplicicidad de esta funci\[OAcute]n (polin\
\[OAcute]mica de grado no muy alto), es posible calcular directamente los \
ceros de la funci\[OAcute]n derivada con el comando ",
  StyleBox["NSolve",
    FontWeight->"Bold"],
  " (prueba con Solve y enteder\[AAcute]s por qu\[EAcute])",
  StyleBox[".",
    FontWeight->"Bold"]
}], "Text"],

Cell[BoxData[{
    \(NSolve[\(f'\)[x] \[Equal] 0, x]\), 
    \(pcrit = x /. %\  (*
      obtenemos\ los\ puntos\ cr\[IAcute]ticos\ como\ una\ lista\ de\ 
        n\[UAcute]meros*) \)}], "Input"],

Cell["\<\
Como vemos, aparecen cuatro soluciones que se corresponden con los extremos \
que hab\[IAcute]amos localizado a simple vista. Usando la derivada segunda \
podemos comprobar que efectivamente dichos puntos son extremos relativos.\
\>", "Text"],

Cell[BoxData[
    \(Map[\(f'\)', pcrit]\)], "Input"],

Cell[TextData[{
  "Podemos pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que muestre en pantalla la informaci\[OAcute]n obtenida. Para ello \
definimos una funci\[OAcute]n que selecciona extremos relativos."
}], "Text"],

Cell[BoxData[
    \(\(seleccionaextremos[func_]\)[x_] := 
      Which[\(\(func'\)'\)[x] > 0, 
        Print["\<x=\>", 
          x, \ "\< es un m\[IAcute]nimo relativo.\>"], \(\(func'\)'\)[x] < 0, 
        Print["\<x=\>", 
          x, \ "\< es un m\[AAcute]ximo relativo.\>"], \(\(func'\)'\)[x] == 
          0, Print["\<El criterio de la derivada segunda no permite \
clasificar el punto cr\[IAcute]tico x= \>", x]]\)], "Input"],

Cell["\<\
Las variables de la funci\[OAcute]n \"seleccionaextremos[func][x]\" que \
acabamos de definir son una funci\[OAcute]n \"func\", que debemos tener \
definida previamente, y un valor num\[EAcute]rico \"x\" en el que puede ser \
evaluada \"func\".\
\>", "Text"],

Cell[BoxData[
    \(\(Map[seleccionaextremos[f], pcrit];\)\)], "Input"],

Cell["Ejemplo 2", "Subsubsection"],

Cell[TextData[{
  "No todas  las funciones permiten calcular de un modo simple las soluciones \
de la ecuaci\[OAcute]n ",
  StyleBox["f '(x)=0",
    FontSlant->"Italic"],
  ". Por ejemplo, consideremos ahora la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ")",
  StyleBox["=",
    FontSlant->"Italic"],
  "sen(x)+",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["e", 
          StyleBox["x",
            FontSlant->"Italic"]], TraditionalForm]]],
  " en el intervalo [-7,0]",
  Cell[BoxData[
      FormBox[
        StyleBox[\( . \ \),
          FontSlant->"Plain"], TraditionalForm]]]
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] = \ Sin[x] + Exp[x]; \nPlot[f[x], {x, \(-7\), 0}]; \)}], "Input"],

Cell[TextData[{
  "De nuevo, a simple vista se observa que hay un m\[AAcute]ximo relativo \
cerca de -5, y un m\[IAcute]nimo relativo cerca de -2. Sin embargo, ahora no \
funciona satisfactoriamente el comando ",
  StyleBox["NSolve",
    FontWeight->"Bold"],
  " (int\[EAcute]ntalo). Optaremos por utilizar el comando ",
  StyleBox["FindRoot",
    FontWeight->"Bold"],
  " para encontrar los posibles puntos cr\[IAcute]ticos de la funci\[OAcute]n \
",
  StyleBox["f",
    FontSlant->"Italic"],
  ". Recordemos que en este comando es necesario introducir una \"primera \
aproximaci\[OAcute]n\" de la soluci\[OAcute]n. En este caso concreto, y dada \
la informaci\[OAcute]n que hemos obtenido de la gr\[AAcute]fica, probaremos a \
iniciar el m\[EAcute]todo desde -5 y tambi\[EAcute]n desde -2."
}], "Text"],

Cell[BoxData[
    \({FindRoot[\(f'\)[x], {x, \(-5\)}], FindRoot[\(f'\)[x], {x, \(-2\)}]}
      \)], "Input"],

Cell["\<\
El programa nos da entonces una buena aproximaci\[OAcute]n de los puntos \
donde la funci\[OAcute]n alcanza los extremos observados.\
\>", "Text"],

Cell["Ejemplo 3", "Subsubsection"],

Cell[TextData[{
  "A continuaci\[OAcute]n veremos un caso en el que la representaci\[OAcute]n \
gr\[AAcute]fica puede llevar a enga\[NTilde]o. Descubriremos el error gracias \
al \"test de la segunda derivada\". Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ")",
  StyleBox["=",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm
      \`x\^2 - 10  x - 40 + 1\/\(10  x\^2 - 100  x + 251\)\)]],
  " ",
  " y represent\[EAcute]mosla en el intervalo [-15,15]."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] = \ x^2 - 10  x - 40 + 1\/\(10  x^2 - 100  x + 251\); \n
    Plot[f[x], {x, \(-15\), 15}]; \)}], "Input"],

Cell[TextData[{
  "A la vista de la gr\[AAcute]fica anterior parece que en ",
  StyleBox["x=",
    FontSlant->"Italic"],
  "5 hay un m\[IAcute]nimo de la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". Calculemos los puntos cr\[IAcute]ticos de la funci\[OAcute]n y evaluemos \
en ellos la derivada segunda."
}], "Text"],

Cell[BoxData[{
    \(NSolve[\(f'\)[x] == 0, x]\n\), 
    \(pcrit = x /. %\  (*hay\ dos\ soluciones\ imaginarias*) \n\), 
    \(reales[x_] := Im[x] \[Equal] 0; \[IndentingNewLine]\n
    pcrit = Select[%, reales] (*
      seleccionamos\ los\ puntos\ cr\[IAcute]ticos\ reales*) \n\), 
    \(\(Map[seleccionaextremos[f], pcrit]; \)\)}], "Input"],

Cell[CellGroupData[{

Cell["\<\
\[DownExclamation]Sorpresa!, en x=5 hay un m\[AAcute]ximo relativo. Ser\
\[IAcute]a  conveniente, entonces, ver \"m\[AAcute]s de cerca\" lo que ocurre \
en x=5. Para ello basta representar la gr\[AAcute]fica en un intervalo \
adecuado.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Plot[f[x], {x, 4, 6}]; 
    \) (*observa\ que\ Mathematica\ ha\ elegido\ como\ origen\ de\ coordendas
        \ el\ punto\ \((\(-64\), 0)\)\ pues\ de\ esta\ forma\ se\ muestran\ 
        mejor\ los\ detalles\ de\ la\ gr\[AAcute]fica*) \)\)], "Input"],

Cell["Ejemplo 4 (propuesto en los apuntes del curso)", "Subsubsection"],

Cell["\<\
Se desa construir una ventana con forma de rect\[AAcute]ngulo coronado de un \
semic\[IAcute]rculo de di\[AAcute]metro igual a la base del \
rect\[AAcute]ngulo. Pondremos cristal blanco en la parte rectangular y \
cristal de color en el semic\[IAcute]rculo. Sabiendo que el cristal coloreado \
deja pasar la mitad de luz (por unidad de superficie) que el blanco, calcular \
las dimensiones para conseguir la m\[AAcute]xima luminosidad si se ha de \
mantener el per\[IAcute]metro constante dado.\
\>", "Text"],

Cell[TextData[{
  "Llamemos x a la longitud de la base de la ventana y h a su altura. El per\
\[IAcute]metro es  una cantidad dada A; es decir ",
  StyleBox["x+2 h+",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\(\[Pi]\ x\)\/2 = A\)],
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"],
  " Despejamos h en funci\[OAcute]n de x."
}], "Text"],

Cell[BoxData[
    \(Clear[h, f]\)], "Input"],

Cell[BoxData[
    \(Solve[x + 2  h + \(Pi\ x\)\/2 == A, h]\)], "Input"],

Cell["La luminosidad viene dada por.", "Text"],

Cell[BoxData[
    \(\(f[x_] = 2\ x\ h + \ Pi\ \ \ x^2\/8;\)\n (*
      sustituimos\ ahora\ el\ valor\ de\ h\ obtenido\ antes*) ; \n
    f[x_] = f[x] /. %\)], "Input"],

Cell["\<\
Observa que hemos obtenido una lista. Pero nosotros queremos una funci\
\[OAcute]n que tome valores num\[EAcute]ricos. Para ello debemos quitar el s\
\[IAcute]mbolo de lista.\
\>", "Text"],

Cell[BoxData[
    \(f[x_] = \(f[x]\)[\([1]\)]\)], "Input"],

Cell["Finalmente, simplficamos.", "Text"],

Cell[BoxData[
    \(f[x_] = Simplify[%]; \nf[x]\)], "Input"],

Cell["Calculamos los puntos cr\[IAcute]ticos:", "Text"],

Cell[BoxData[
    \(x /. Solve[\(f'\)[x] == 0, x]\)], "Input"],

Cell[TextData[{
  "Observa que la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un polinomio de grado dos que representa una par\[AAcute]bola y, como \
el coeficiente de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  " es negativo, dicha funci\[OAcute]n tiene un m\[AAcute]ximo absoluto en el \
punto donde se anula su derivada."
}], "Text"],

Cell["Polinomios de Taylor", "Section"],

Cell[TextData[{
  "Recuerda que el polinomio de Taylor de orden ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " es la funci\[OAcute]n polin\[OAcute]mica "
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{\(\(T(f, a, n)\) \((x)\)\), "=", 
              RowBox[{\(f(a)\), "+", 
                
                FormBox[
                  \(\[Sum]\+\(k = 1\)\%n\(\(\( f\^\((k)\)\)(a)\)\/\(k!\)\) 
                      \((x - a)\)\^k\),
                  "TraditionalForm"]}]}],
            "TraditionalForm"], "."}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Dicho polinomio puede calcularse con el comando Normal[Series[f[x],{x,a,n}]] \
.\
\>", "Text"],

Cell[BoxData[
    \(Normal[Series[Exp[x], {x, 0, 6}]]\)], "Input"],

Cell["\<\
La orden Animate o Table  o Do  (que ya conoces)  permite hacer animaciones \
de la gr\[AAcute]fica de una funci\[OAcute]n y sus polinomios de Taylor. \
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] = Cos[x] + Sin[x]; 
    \[IndentingNewLine]Animate[
      Plot[Evaluate[{f[x], Normal[Series[f[x], {x, 0, n}]]}], 
        \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {x, 
          \(-3\) Pi, 3  Pi}, PlotStyle \[Rule] {Hue[0], Hue[ .65]}, 
        \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
        PlotRange \[Rule] {\(-3\), 3}], 
      \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ {n, 1, 31, 3}]; \n
    SelectionMove[EvaluationNotebook[], All, GeneratedCell]; \n
    FrontEndTokenExecute["\<CellGroup\>"]\), 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell["Ejercicios", "ExerciseMain"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  " Calcula los puntos cr\[IAcute]ticos (puntos donde se anula la derivada)  \
de \n",
  Cell[BoxData[
      \(TraditionalForm
      \`f(x) = 0.487856844000000045`\ x - 0.417176730000000084`\ x\^2 - 
          4.13604445200000103`\ x\^3 + 3.01853713499999765`\ x\^4 + 
          13.044581959999999`\ x\^5 - 13.0802496666666723`\ x\^6 - 
          0.983014285714284596`\ x\^7 + 1.07624999999999926`\ x\^8 - 
          9.44444444444444641`\ x\^9 + 10\ x\^10\)]],
  "\ny usa la derivada segunda para clasificar los puntos cr\[IAcute]ticos \
reales. Calcula los puntos de inflexi\[OAcute]n. Finalmente, representa gr\
\[AAcute]ficamente la funci\[OAcute]n en un intervalo apropiado para \
confirmar los resultados obtenidos.\nSugerencia. Haz un peque\[NTilde]o \
programa que imprima en pantalla los resultados que buscas y la informaci\
\[OAcute]n interesante. "
}], "ExerciseText"]
}, Open  ]],

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Calcula las tangentes a la hip\[EAcute]rbola ",
  Cell[BoxData[
      \(TraditionalForm\`x\ y = 1\)]],
  " que pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\), 1)\)\)]],
  ". Haz una representaci\[OAcute]n gr\[AAcute]fica.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Calcula las tangentes a la gr\[AAcute]fica de  ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2\ x\^3 + 13  x\^2 + 5  x + 9\)]],
  " que pasan por el origen. Haz una representaci\[OAcute]n gr\[AAcute]fica."
}], "ExerciseText"],

Cell["Ejercicio 3", "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en azul \
los cocientes incrementales de la funci\[OAcute]n seno \"cocienteinc[Sin, \
h][x]\" (ver definici\[OAcute]n arriba) para h variando desde -2 a -0.1 con \
incrementos de 0.2, la funci\[OAcute]n seno en rojo y la funci\[OAcute]n \
coseno en verde, para x entre -2Pi y 2Pi.\
\>", "ExerciseText"],

Cell["Ejercicio 4", "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en rojo la \
funci\[OAcute]n seno y en azul sus polinomios de Taylor de orden n centrados \
en 0, donde n toma valores desde 1 a 21 con incrementos de 2. Haz la \
representaci\[OAcute]n en el intervalo [-2Pi, 2Pi] y en el [-8Pi, 8Pi].  \
Debes fijar, con \"PlotRange[ ]\", un intervalo de representaci\[OAcute]n com\
\[UAcute]n para todas las gr\[AAcute]ficas de la animaci\[OAcute]n.Comenta lo \
que obervas.\
\>", "ExerciseText"],

Cell["Ejercicio 5", "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en rojo la \
funci\[OAcute]n arco tangente y en azul sus polinomios de Taylor de orden n \
centrados en 0, donde n toma valores desde 1 a 21 con incrementos de 2. Haz \
la representaci\[OAcute]n en el intervalo [-1,1} y en  [-Pi/2, Pi/2]. Debes \
fijar, con \"PlotRange[ ]\", un intervalo de representaci\[OAcute]n com\
\[UAcute]n para todas las gr\[AAcute]ficas de la animaci\[OAcute]n. Comenta \
lo que obervas.\
\>", "ExerciseText"],

Cell["Ejercicio 6", "Exercise"],

Cell["\<\
Haz una animaci\[OAcute]n gr\[AAcute]fica en la que se representen en rojo la \
funci\[OAcute]n Log(1+x) y en azul sus polinomios de Taylor de orden n \
centrados en 0, donde n toma valores desde 1 a 21 con incrementos de 2. Haz \
la representaci\[OAcute]n en el intervalo [-.9,1] y en  [-.9, 3]. Debes \
fijar, con \"PlotRange[ ]\", un intervalo de representaci\[OAcute]n com\
\[UAcute]n para todas las gr\[AAcute]ficas de la animaci\[OAcute]n. Comenta \
lo que obervas.\
\>", "ExerciseText"],

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  StyleBox["a) ",
    FontWeight->"Bold"],
  "Define una funci\[OAcute]n cuya sintaxis debe ser de la forma \
\"rectanormal[f,a][x]\", cuyo resultado sea la recta normal a la \
gr\[AAcute]fica de la funci\[OAcute]n f en el punto (a,f(a)). Debes definir \
una funci\[OAcute]n condicionada seg\[UAcute]n que f '(a)\[NotEqual]0 o que f \
'(a)=0.\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Representa gr\[AAcute]ficamente (en una sola gr\[AAcute]fica y en azul) \
la familia de rectas normales a la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\/4\)]],
  ". En la misma gr\[AAcute]fica representa tambi\[EAcute]n la \
par\[AAcute]bola en rojo y con grosor apropiado. Haz la \
representaci\[OAcute]n para x\[Element][-6,6]. Representa las rectas normales \
en los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_k, f(x\_k))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  " son 101 puntos igualmente espaciados en el intervalo [-6,6]. \n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Sobre la gr\[AAcute]fica anterior representa, en rojo y con grosor \
apropiado, la gr\[AAcute]fica de la curva ",
  Cell[BoxData[
      \(TextForm\`\(\ y = 2 + \@\(\(27\/4\) x\^2\)\%3\)\)]],
  " y oberva que las rectas normales a la par\[AAcute]bola son tangentes a \
dicha curva que se llama la evoluta de la par\[AAcute]bola.\n"
}], "ExerciseText"],

Cell["C\[AAcute]lculo de integrales", "Section"],

Cell["\<\
Los comandos b\[AAcute]sicos que se usan para calcular integrales son \
\"Integrate[ ]\" para hacer c\[AAcute]lculos simb\[OAcute]licos y \
\"NIntegrate[ ]\" para calcular una aproximaci\[OAcute]n num\[EAcute]rica de \
una integral. Estos comandos tienen varias opciones que vamos a ver a \
continuaci\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Integrate[x*Sin[x], x]\ \) (*\ 
      Integrate[f[x], x]\ proporciona\ una\ primitiva\ de\ f[x]\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(\(\(Integrate[x\^2*\ Exp[x], {x, \[Pi]/2, \[Pi]}]\)\(\ \)\( (*\ 
      Integrate[f[x], {x, a, b}]\ calcula\ el\ valor\ de\ la\ integral\ de\ f[
          x] en\ el\ intervalo\ [a, b], \ \(-\[Infinity]\) \[LessEqual] a < 
        b \[LessEqual] \[Infinity]\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Para calcular una integral definida que depende de un par\[AAcute]metro \
puedes informar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de las carcater\[IAcute]sticas de dicho par\[AAcute]metro. Si no lo haces \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " intentar\[AAcute] dar una respuesta v\[AAcute]lida imponiendo, si es \
necesario, algunas restricciones al par\[AAcute]metro. Cuando se calculan \
primitivas ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no se preocupa de valores particulares de los par\[AAcute]metros. F\
\[IAcute]jate bien en las respuestas a los siguientes comandos."
}], "Text"],

Cell[BoxData[{
    \(Integrate[Exp[\(-a\)*x], x]\), 
    \(Integrate[Exp[\(-a\)*x], {x, 0, \[Infinity]}]\), 
    \(Integrate[Exp[\(-a\)*x], {x, 0, \[Infinity]}, Assumptions \[Rule] a > 0]
      \)}], "Input"],

Cell[TextData[{
  "En la primera ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se ha limitado a calcular una primitiva. En la segunda dice que si el par\
\[AAcute]metro ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " tiene parte real positiva (quiz\[AAcute]s debas saber que para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " todas las variables son por defecto variables complejas) la integral vale \
",
  Cell[BoxData[
      \(TraditionalForm\`1/a\)]],
  ". En la tercera nos da el valor de la integral cuando ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(NIntegrate[Exp[x^3], {x, 0, 1}]\)\( (*\ 
      NIntegrate[
          f[x], {x, a, 
            b}]\ calcula\ num\[EAcute]ricamente\ la\ integral\ de\ f[
          x]\ en\ el\ intervalo\ [a, b]\ *) \)\)\)], "Input"],

Cell["\<\
A veces el comando \"NIntegrate[ ]\" necesita ayuda. Aqu\[IAcute] tienes un \
ejemplo de esto.\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[\((1/x)\)*\ Sin[1/x], {x,  .001, 1}]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " te informa de que el resultado no es fiable. En este caso es debido a que \
la funci\[OAcute]n oscila demasiado. Cuando esto ocurre podemos intentar \
aumentar el n\[UAcute]mero de iteraciones con la opci\[OAcute]n \
\"MaxRecursion\", la precisi\[OAcute]n de los c\[AAcute]lculos con la opci\
\[OAcute]n \"WorkingPrecision\" o bien usar otras opciones (que debes \
consultar en la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[BoxData[
    \(NIntegrate[\((1/x)\)*Sin[1/x], {x,  .001, 1}, 
      MaxRecursion \[Rule] 20]\)], "Input"],

Cell["Ejercicios", "ExerciseMain"],

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Calcula num\[EAcute]ricamente las integrales en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-2\), 2]\)\)]],
  " de los primeros 20 polinomios de Taylor centrados en 0 de la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`e\^\(-x\^2\)\)]],
  ". Calcula tambi\[EAcute]n num\[EAcute]ricamente la integral de dicha funci\
\[OAcute]n en el mismo intervalo."
}], "ExerciseText"],

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "Calcula sumas de Riemann de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\  = \ \(\((1/x)\)\ \(Cos(1/x)\)\ \)\)]],
  "en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([1/100, 1]\)\)]],
  " y compara los valores obtenidos con los que proporciona el comando \
\"NIntegrate[ ]\" con las opciones oportunas. Debes lograr que la diferencia \
entre ambos resultados sea menor que ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-3\)\)]],
  ". "
}], "ExerciseText"],

Cell[CellGroupData[{

Cell["Ejercicio 10", "Exercise"],

Cell[TextData[{
  "Define un comando que calcule sumas de Riemann de una funci\[OAcute]n de \
una variable. La funci\[OAcute]n debe evaluarse en el punto medio de cada \
intervalo de la partici\[OAcute]n.\n",
  StyleBox["Sugerencias",
    FontWeight->"Bold"],
  ". Debes definir un comando de la forma \"sumarieman[func_,a_,b_,n_]\" \
donde las variables son la funci\[OAcute]n de una variable, \"func\", los \
extremos del intervalo, [a,b], y el n\[UAcute]mero de partes iguales, n, en \
que se divide dicho intervalo. La salida del comando debe ser la suma de los \
valores de \"func\" en los puntos medios de todos los subintervalos \
multiplicada por la longitud de dichos subintervalos. Este n\[UAcute]mero, \
para n suficientemente grande, es una buena aproximaci\[OAcute]n de la \
integral ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(x)\) \[DifferentialD]x\)]],
  ". Por supuesto, este comando debe trabajar num\[EAcute]ricamente. \nAplica \
tu comando a las funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \((1/x)\) \(Cos(1/x)\)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([1/100, 1]\)\)]],
  " dividido en 40000 partes iguales. Comprueba la duraci\[OAcute]n del c\
\[AAcute]lculo con el comando Timing[ ] (si tu comando est\[AAcute] bien \
definido, este c\[AAcute]lculo debe hacerse en menos de 0.7 segundos). \
Comprueba tu resultado usando el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " NIntegrate[ ] para calcular num\[EAcute]ricamente la integral de ",
  Cell[BoxData[
      \(TraditionalForm\`Cos[1/x]/x\)]],
  " en el intervalo [1/100,1]."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Derivadas e integrales."], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Derivadas e integrales."], "Header"]}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 40, 0, 69, "Title"],
Cell[1752, 51, 203, 3, 72, "Author"],
Cell[1958, 56, 39, 0, 69, "Section"],
Cell[2000, 58, 493, 9, 165, "Text"],
Cell[2496, 69, 116, 3, 69, "Section"],
Cell[2615, 74, 265, 6, 33, "Text"],
Cell[2883, 82, 212, 5, 123, "Input"],
Cell[3098, 89, 676, 17, 75, "Text"],
Cell[3777, 108, 104, 3, 102, "Input"],
Cell[3884, 113, 61, 0, 33, "Text"],
Cell[3948, 115, 47, 1, 60, "Input"],
Cell[3998, 118, 1196, 31, 97, "Text"],
Cell[5197, 151, 85, 2, 102, "Input"],
Cell[5285, 155, 219, 6, 33, "Text"],

Cell[CellGroupData[{
Cell[5529, 165, 58, 0, 69, "Section"],
Cell[5590, 167, 1118, 34, 90, "Text"],
Cell[6711, 203, 234, 5, 95, "Input"],
Cell[6948, 210, 369, 11, 33, "Text"],
Cell[7320, 223, 89, 1, 60, "Input"],
Cell[7412, 226, 899, 25, 75, "Text"],
Cell[8314, 253, 558, 10, 207, "Input"]
}, Open  ]],
Cell[8887, 266, 167, 4, 39, "Text"],
Cell[9057, 272, 548, 10, 207, "Input"],

Cell[CellGroupData[{
Cell[9630, 286, 42, 0, 69, "Section"],
Cell[9675, 288, 112, 3, 33, "Text"],
Cell[9790, 293, 222, 3, 95, "Input"]
}, Open  ]],
Cell[10027, 299, 315, 9, 33, "Text"],
Cell[10345, 310, 98, 2, 86, "Input"],
Cell[10446, 314, 62, 0, 69, "Section"],
Cell[10511, 316, 665, 18, 77, "Text"],
Cell[11179, 336, 34, 0, 46, "Subsubsection"],
Cell[11216, 338, 352, 11, 33, "Text"],
Cell[11571, 351, 140, 3, 102, "Input"],
Cell[11714, 356, 605, 12, 220, "Text"],
Cell[12322, 370, 194, 4, 81, "Input"],
Cell[12519, 376, 252, 4, 54, "Text"],
Cell[12774, 382, 52, 1, 60, "Input"],
Cell[12829, 385, 242, 6, 33, "Text"],
Cell[13074, 393, 430, 8, 102, "Input"],
Cell[13507, 403, 268, 5, 54, "Text"],
Cell[13778, 410, 71, 1, 60, "Input"],
Cell[13852, 413, 34, 0, 46, "Subsubsection"],
Cell[13889, 415, 671, 25, 54, "Text"],
Cell[14563, 442, 111, 2, 102, "Input"],
Cell[14677, 446, 804, 17, 97, "Text"],
Cell[15484, 465, 108, 2, 60, "Input"],
Cell[15595, 469, 156, 3, 33, "Text"],
Cell[15754, 474, 34, 0, 46, "Subsubsection"],
Cell[15791, 476, 538, 17, 58, "Text"],
Cell[16332, 495, 151, 3, 118, "Input"],
Cell[16486, 500, 337, 9, 54, "Text"],
Cell[16826, 511, 341, 6, 228, "Input"],

Cell[CellGroupData[{
Cell[17192, 521, 259, 5, 54, "Text"],
Cell[17454, 528, 274, 4, 81, "Input"],
Cell[17731, 534, 71, 0, 46, "Subsubsection"],
Cell[17805, 536, 518, 8, 75, "Text"],
Cell[18326, 546, 380, 11, 36, "Text"],
Cell[18709, 559, 44, 1, 60, "Input"],
Cell[18756, 562, 71, 1, 73, "Input"],
Cell[18830, 565, 46, 0, 33, "Text"],
Cell[18879, 567, 166, 3, 118, "Input"],
Cell[19048, 572, 198, 4, 33, "Text"],
Cell[19249, 578, 58, 1, 60, "Input"],
Cell[19310, 581, 41, 0, 33, "Text"],
Cell[19354, 583, 60, 1, 81, "Input"],
Cell[19417, 586, 55, 0, 33, "Text"],
Cell[19475, 588, 62, 1, 60, "Input"],
Cell[19540, 591, 372, 10, 54, "Text"],
Cell[19915, 603, 39, 0, 69, "Section"],
Cell[19957, 605, 318, 11, 33, "Text"],
Cell[20278, 618, 488, 14, 70, "Text"],
Cell[20769, 634, 104, 3, 33, "Text"],
Cell[20876, 639, 66, 1, 60, "Input"],
Cell[20945, 642, 175, 3, 33, "Text"],
Cell[21123, 647, 653, 12, 228, "Input"],
Cell[21779, 661, 34, 0, 67, "ExerciseMain"],

Cell[CellGroupData[{
Cell[21838, 665, 31, 0, 48, "Exercise"],
Cell[21872, 667, 895, 16, 138, "ExerciseText"]
}, Open  ]],
Cell[22782, 686, 31, 0, 48, "Exercise"],
Cell[22816, 688, 587, 16, 64, "ExerciseText"],
Cell[23406, 706, 31, 0, 48, "Exercise"],
Cell[23440, 708, 379, 6, 54, "ExerciseText"],
Cell[23822, 716, 31, 0, 48, "Exercise"],
Cell[23856, 718, 508, 8, 75, "ExerciseText"],
Cell[24367, 728, 31, 0, 48, "Exercise"],
Cell[24401, 730, 512, 8, 75, "ExerciseText"],
Cell[24916, 740, 31, 0, 48, "Exercise"],
Cell[24950, 742, 503, 8, 75, "ExerciseText"],
Cell[25456, 752, 31, 0, 48, "Exercise"],
Cell[25490, 754, 1412, 32, 224, "ExerciseText"],
Cell[26905, 788, 48, 0, 69, "Section"],
Cell[26956, 790, 336, 6, 54, "Text"],
Cell[27295, 798, 142, 3, 60, "Input"],
Cell[27440, 803, 297, 4, 102, "Input"],
Cell[27740, 809, 667, 16, 75, "Text"],
Cell[28410, 827, 208, 4, 102, "Input"],
Cell[28621, 833, 617, 19, 54, "Text"],
Cell[29241, 854, 238, 5, 81, "Input"],
Cell[29482, 861, 118, 3, 33, "Text"],
Cell[29603, 866, 80, 1, 60, "Input"],
Cell[29686, 869, 535, 12, 75, "Text"],
Cell[30224, 883, 110, 2, 60, "Input"],
Cell[30337, 887, 34, 0, 67, "ExerciseMain"],
Cell[30374, 889, 31, 0, 48, "Exercise"],
Cell[30408, 891, 423, 10, 57, "ExerciseText"],
Cell[30834, 903, 31, 0, 48, "Exercise"],
Cell[30868, 905, 514, 13, 54, "ExerciseText"],

Cell[CellGroupData[{
Cell[31407, 922, 32, 0, 48, "Exercise"],
Cell[31442, 924, 1669, 33, 219, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

